/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "CClient.h"

#include "MainFrm.h"
#include "CSecDialog.h"
#include "ISecDialog.h"
#include "HSecDialog.h"
#include "OSecDialog.h"
#include "LSecDialog.h"
#include "TSecDialog.h"

#include "SquareBolt.h"
#include "HexBoltDlg.h"
#include "SquareHeadedDlg.h"
#include "THeadedBoltDlg.h"
#include "funcheader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(ID_MATEPLANES, OnUpdateMateplanes)
	ON_UPDATE_COMMAND_UI(ID_ORIENTAXES, OnUpdateOrientaxes)
	ON_UPDATE_COMMAND_UI(ID_CREATE_SWEEP, OnUpdateCreateSweep)
	ON_UPDATE_COMMAND_UI(ID_SETDRAWINGNAME, OnUpdateSetdrawingname)
	ON_UPDATE_COMMAND_UI(ID_SETDRAWINGTITLE, OnUpdateSetdrawingtitle)
	ON_UPDATE_COMMAND_UI(ID_HIDE_OTHER_SKETCHES, OnUpdateHideOtherSketches)
	ON_UPDATE_COMMAND_UI(ID_MID_PLANE, OnUpdateMidPlane)
	ON_UPDATE_COMMAND_UI(ID_NEW_SKETCH, OnUpdateNewSketch)
	ON_UPDATE_COMMAND_UI(ID_OFFSET_PLANE, OnUpdateOffsetPlane)
	ON_UPDATE_COMMAND_UI(ID_ORIENTED_PLANE, OnUpdateOrientedPlane)
	ON_UPDATE_COMMAND_UI(ID_PLANE_OF_OBJECT, OnUpdatePlaneOfObject)
	ON_UPDATE_COMMAND_UI(ID_PLANE_THROUGH_OBJECTS, OnUpdatePlaneThroughObjects)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_COMPONENT_BROWSER, OnComponentBrowser)
	ON_COMMAND(ID_ISECTION, OnIsection)
	ON_COMMAND(ID_CSECTION, OnCsection)
	ON_COMMAND(ID_LSECTION, OnLsection)
	ON_COMMAND(ID_TSECTION, OnTsection)
	ON_COMMAND(ID_OSECTION, OnOsection)
	ON_COMMAND(ID_HSECTION, OnHsection)
	ON_COMMAND(ID_SQUAREBOLT, OnSquarebolt)
	ON_COMMAND(ID_BOLTS, OnBolts)
	ON_UPDATE_COMMAND_UI(ID_BOLTS, OnUpdateBolts)
	ON_COMMAND(ID_HEXBOLT, OnHexbolt)
	ON_COMMAND(ID_SQUAREHEADED, OnSquareheaded)
	ON_COMMAND(ID_T_HEADED_BOLT, OnTHeadedBolt)
	ON_UPDATE_COMMAND_UI(ID_SQUAREBOLT, OnUpdateSquarebolt)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_COMPONENTS))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	if (!m_wndToolBar1.Create(this) ||
		!m_wndToolBar1.LoadToolBar(IDR_BOLTS))
	{
		TRACE0("Failed to create toolbar\n");
	}
	
	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar1.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar1.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar1);	



	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	cs.x = 0;
	cs.y = 0;
	cs.cx = 750;
	cs.cy = 150;

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers



void CMainFrame::OnUpdateMateplanes(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
//	pCmdUI->Enable(FALSE);
}

void CMainFrame::OnUpdateOrientaxes(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
//	pCmdUI->Enable(FALSE);
}

void CMainFrame::OnUpdateCreateSweep(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateSetdrawingname(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateSetdrawingtitle(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateHideOtherSketches(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateMidPlane(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateNewSketch(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateOffsetPlane(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdateOrientedPlane(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdatePlaneOfObject(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnUpdatePlaneThroughObjects(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(FALSE);
	
}

void CMainFrame::OnComponentBrowser() 
{

}

void CMainFrame::OnIsection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CISecDialog dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}

	if (ReleaseHelmProDESKTOP()) 
		return;

}

void CMainFrame::OnCsection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CCSecDialog dlg ;

	if(dlg.DoModal() == TRUE)
	{
	}
	
	if (ReleaseHelmProDESKTOP()) 
		return;

}

void CMainFrame::OnLsection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CLSecDialog dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnTsection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CTSecDialog dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnOsection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	COSecDialog dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnHsection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CHSecDialog dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnSquarebolt() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CSquareBolt dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnBolts() 
{
//	if (GetHelmProDESKTOP()) 
//		return;

	BOOL visible = m_wndToolBar1.GetStyle() & WS_VISIBLE;
	m_wndToolBar1.GetDockingFrame()->ShowControlBar(&m_wndToolBar1, !visible, FALSE);
//	if (ReleaseHelmProDESKTOP()) 
//		return;
}

void CMainFrame::OnUpdateBolts(CCmdUI* pCmdUI) 
{

	// TODO: Add your command update UI handler code here
	BOOL visible = m_wndToolBar1.GetStyle() & WS_VISIBLE;
	pCmdUI->SetCheck(visible) ;
	
}

void CMainFrame::OnHexbolt() 
{

	if (GetHelmProDESKTOP()) 
		return;

	CHexBoltDlg dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnSquareheaded() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CSquareHeadedDlg dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnTHeadedBolt() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CTHeadedBoltDlg dlg ;
	if(dlg.DoModal() == TRUE)
	{
	}	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CMainFrame::OnUpdateSquarebolt(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

}
